<?php
// description: Add CKFinder module to simply manipulate images and files.
function create_file_from_zip($pathdir, $filename, $data)
{
    $fail = array();
    $path = SERVDIR;
    foreach(explode('/', $pathdir) as $dir)
    {
        $path .= '/'.$dir;
        if(!is_dir($path))
            if(!mkdir($path)) $fail[] = array('Cannot create the folder ', $path);;
    }
    $w = fopen($path.'/'.$filename, 'w');
    if(!$w) $fail[] = array('Cannot open the file ', $path.'/'.$filename);
    if(!fwrite($w, $data)) $fail[] = array('Cannot create the file', $path.'/'.$filename);
    fclose($w);

    return $fail;
}

if(!file_exists(SERVDIR.'/ckfinder'))
{
    add_hook('more_options', 'add_install_to_options');
    add_hook('options_additional_actions', 'run_install');

    function add_install_to_options($options)
    {
        $PHP_SELF = PHP_SELF;

        $options[] = array
        (
            'name'              => lang('Install ckfinder plugin', 'options'),
            'url'               => "$PHP_SELF?mod=options&action=ckfinderinst",
            'access'            => ACL_LEVEL_ADMIN,
        );

        return $options;
    }

    function run_install()
    {
        if (REQ('action','GET') == 'ckfinderinst')
        {
            if(is_writable(SERVDIR))
            {
                require SERVDIR."/core/zip.class.php";
                $zipfile = new zipfile;
                $zipfile->read_zip(SERVDIR.'/cdata/plugins/ckfinder.zip');

                $fail = array();

                foreach($zipfile->files as $filea)
                    $fail = array_merge($fail, create_file_from_zip($filea['dir'], $filea['name'], $filea['data']));

                if(count($fail) == 0) unlink(SERVDIR.'/cdata/plugins/ckfinder.zip');

                $found_problems = proc_tpl('install/problemlist', array('fail' => $fail));
                msg('info', lang('Installation success'), lang("Congrats! You installed ckfinder plugin."). " | <a href='../index.php'>Main page</a> ".$found_problems);
            }
            else
            {
                msg('info', lang('Installation error'), "Cannot install automatic. Please, unzip ckfinder.zip from plugins folder to the root of the site manualy. | <a href='../index.php'>Main page</a> ");
            }
        }
    }
}
else
{
    add_hook('implement_file_browser', 'add_ckfinder_to_cke');

    function add_ckfinder_to_cke($data)
    {
        global $config_http_script_dir;

        if(preg_match('~(filebrowserBrowseUrl:\s*)\'(.*)\'~',$data, $match))
        {
            $data = str_replace($match[0], $match[1]."'".$config_http_script_dir."/ckfinder/ckfinder.html'", $data);
        }
        else
            $data .= ",
                filebrowserBrowseUrl: '".$config_http_script_dir."/ckfinder/ckfinder.html'";

        if(preg_match('~(filebrowserImageBrowseUrl:\s*)\'(.*)\'~',$data, $match))
        {
            $data = str_replace($match[0], $match[1]."'".$config_http_script_dir."/ckfinder/ckfinder.html?type=Images'", $data);
        }
        else
            $data .= ",
                filebrowserImageBrowseUrl: '".$config_http_script_dir."/ckfinder/ckfinder.html?type=Images'";

        if(preg_match('~(filebrowserFlashBrowseUrl:\s*)\'(.*)\'~',$data, $match))
        {
            $data = str_replace($match[0], $match[1]."'".$config_http_script_dir."/ckfinder/ckfinder.html?type=Flash'", $data);
        }
        else
            $data .= ",
                filebrowserFlashBrowseUrl: '".$config_http_script_dir."/ckfinder/ckfinder.html?type=Flash'";

        if(preg_match('~(filebrowserUploadUrl:\s*)\'(.*)\'~',$data, $match))
        {
            $data = str_replace($match[0], $match[1]."'".$config_http_script_dir."/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files", $data);
        }
        else
            $data .= ",
                filebrowserUploadUrl: '".$config_http_script_dir."/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files'";

        if(preg_match('~(filebrowserImageUploadUrl:\s*)\'(.*)\'~',$data, $match))
        {
            $data = str_replace($match[0], $match[1]."'".$config_http_script_dir."/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images'", $data);
        }
        else
            $data .= ",
                filebrowserImageUploadUrl: '".$config_http_script_dir."/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Images'";

        if(preg_match('~(filebrowserFlashUploadUrl:\s*)\'(.*)\'~',$data, $match))
        {
            $data = str_replace($match[0], $match[1]."'".$config_http_script_dir."/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'", $data);
        }
        else
            $data .= ",
                filebrowserFlashUploadUrl: '".$config_http_script_dir."/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Flash'";

        return $data;
    }
}

?>