<?php
// description: Advanced Image Module, Clickable thumbs, directories, etc.
add_hook('system_modules_expand', 'advancedImages');
add_hook('show_news_init', 'add_popjs_to_news');
add_hook('implement_file_browser', 'add_to_ckeditor');
add_hook('CKEDITOR_Settings', 'define_plugin_for_ckeditor');


//Create .htaccess file
if(!file_exists(SERVDIR.'/cdata/plugins/advancedimages/.htaccess')){
    $ht_file = fopen(SERVDIR.'/cdata/plugins/advancedimages/.htaccess', 'w');
    $htaccess = "Order Deny,Allow\nDeny From All\n<Files ~ \"\.(js|png|gif|jpg|jpeg)$\">\nOrder Deny,Allow\nallow from all\n</Files>";
    fwrite($ht_file, $htaccess);
    fclose(SERVDIR.'/cdata/plugins/advancedimages/.htaccess');
}

function advancedImages($data)
{
    list($system_modules, $mod, $stop) = $data;

    if($mod == 'images')
    {
        global $config_http_script_dir, $member_db;
        $PHP_SELF = PHP_SELF;

        require ("advancedimages/advancedimages_tools.php");
        $stop = true;
    }

    return array($system_modules, $mod, $stop);
}

function add_popjs_to_news()
{
    global $config_http_script_dir, $template;

    if ($template != 'rss')
    {
        echo '
        <script type="text/javascript">
            function popupMedia(url,width,height) {
                winheight = parseFloat(height) + 30;
                winwidth =  parseFloat(width) + 30;

                newWin=window.open(\'\', \'popupwin\',\'resizable=0,HEIGHT=\'+winheight+\',WIDTH=\'+winwidth+\', scrollbars=0\', true);
                newWin.document.write(\'<html>\n\');
                newWin.document.write(\'<head>\n\');
                newWin.document.write(\'<title>Image</title>\');
                newWin.document.write(\'\x3Cscript language="javascript" type="text/javascript">\n<!--\n\');
                newWin.document.write(\'var arrTemp=self.location.href.split("?");\n\');
                newWin.document.write(\'var picUrl = (arrTemp.length>1)?arrTemp[1]:"";\n\');
                newWin.document.write(\'var NS = (navigator.appName=="Netscape")?true:false;\n\');
                newWin.document.write(\'function fitMedia() {\n\');
                newWin.document.write(\' iWidth = (NS)?window.innerWidth:document.body.clientWidth;\n\');
                newWin.document.write(\' iHeight = (NS)?window.innerHeight:document.body.clientHeight;\n\');
                newWin.document.write(\' iWidth = \'+winwidth+\' - iWidth;\n\');
                newWin.document.write(\' iHeight = \'+winheight+\' - iHeight;\n\');
                newWin.document.write(\' window.resizeBy(iWidth, iHeight);\n\');
                newWin.document.write(\' var posLeft = (window.screen.width - \'+winwidth+\')/2;\n\');
                newWin.document.write(\' window.moveTo(posLeft,80);\n\');
                newWin.document.write(\'};\n\');
                newWin.document.write(\'-->\n\x3C/script>\n\');
                newWin.document.write(\'<style>html,body{height:100%;padding:0px;}</style>\n\');
                newWin.document.write(\'</head>\n\');
                newWin.document.write(\'<body style="background-color:white; margin:0px; padding:0px;">\n\');
                newWin.document.write(\'<table border=0 style="height:100%; width:100%; text-align:center;"><tr><td>\n\');
                newWin.document.write(\'<img src="\'+url+\'" width="\'+width+\'" height="\'+height+\'" alt="" />\');
                newWin.document.write(\'</td>\n</tr>\n</table>\n</body>\n\x3Cscript language="javascript" type="text/javascript">\n<!--\n\');
                newWin.document.write(\'fitMedia();\n\');
                newWin.document.write(\'-->\n\x3C/script>\n\');
                newWin.document.write(\'</html>\');
                newWin.document.close()
                newWin.focus();
            }
        </script>';
    }
}
function add_to_ckeditor($data)
{
    global $config_ckeditor_customize;
    $config_ckeditor_customize .= ", ['advancedimages']";
    $PHP_SELF = PHP_SELF;

    if(preg_match('~(extraPlugins:\s*)\'(.*)\'~',$data, $match))
    {
        $plugins = explode(',', $match[2]);
        $plugins[] = 'advancedimages';
        $data = str_replace($match[0], $match[1].'\''.implode(',', $plugins).'\'', $data);
    }
    else
        $data .= ",
              extraPlugins: 'advancedimages'";

    return $data;
}

function define_plugin_for_ckeditor($data)
{
    global $short_story_id, $full_story_id, $GLOBALS, $config_http_script_dir;
    $PHP_SELF = PHP_SELF;

    $data .= "
        (function() {
            CKEDITOR.plugins.addExternal('advancedimages', '".$config_http_script_dir."/cdata/plugins/advancedimages/', 'plugin.js');
        })();";

    return $data;
}

?>