<?php
// description: Add a module like the image manager, but then for managing files. It is pretty much working like the Cutenews image manager. Another feature is the pagination. By default the hack displays 20 files per page. You can easily change this and other configurations in attach/attach_tools.php at the beginning of the file.

add_hook('more_options', 'add_filemanager_to_options');
add_hook('options_additional_actions', 'run_filemanager');
add_hook('implement_file_browser', 'link_to_file_browser');
add_hook('CKEDITOR_Settings', 'attach_file_to_news');
add_hook('system_modules_expand', 'download_file');
add_hook('template_replacer_news_middle', 'replace_uploaded_file_templates');

//Create .htaccess file
if(!file_exists(SERVDIR.'/cdata/plugins/attach/.htaccess')){
    $ht_file = fopen(SERVDIR.'/cdata/plugins/attach/.htaccess', 'w');
    $htaccess = "Order Deny,Allow\nDeny From All\n<Files ~ \"\.(js|png|gif|jpg|jpeg)$\">\nOrder Deny,Allow\nallow from all\n</Files>";
    fwrite($ht_file, $htaccess);
    fclose(SERVDIR.'/cdata/plugins/attach/.htaccess');
}

function add_filemanager_to_options($options)
{
    $PHP_SELF = PHP_SELF;

    $options[] = array
    (
    'name'              => lang('Manage Uploaded Files', 'options'),
    'url'               => "$PHP_SELF?mod=options&action=fileupload",
    'access'            => ACL_LEVEL_ADMIN,
    );

    return $options;
}

function run_filemanager()
{
    global $member_db, $config_http_script_dir;
    $PHP_SELF = PHP_SELF;

    if (REQ('action','GET') == 'fileupload')
        require ("attach/attach_tools.php");
}

function link_to_file_browser($data)
{
    global $config_ckeditor_customize;
    $config_ckeditor_customize .= ", ['attach']";
    $PHP_SELF = PHP_SELF;

    if(preg_match('~(extraPlugins:\s*)\'(.*)\'~',$data, $match))
    {
        $plugins = explode(',', $match[2]);
        $plugins[] = 'attach';
        $data = str_replace($match[0], $match[1].'\''.implode(',', $plugins).'\'', $data);
    }
    else
        $data .= ",
              extraPlugins: 'attach'";

    return $data;
}

function attach_file_to_news($data)
{
    global $short_story_id, $full_story_id, $GLOBALS, $config_http_script_dir;
    $PHP_SELF = PHP_SELF;

    $GLOBALS['Hook_AdditionalFieldsShort'] = "<p><a href=# onclick=\"window.open('$PHP_SELF?&mod=options&action=fileupload&do=quick&area=$short_story_id', '_Addfile', 'HEIGHT=500,resizable=yes,scrollbars=yes,WIDTH=360');return false;\" target=\"_Addfile\"><br />[insert file]</a><br /></p>";
    $GLOBALS['Hook_AdditionalFieldsFull']  = "<p><a href=# onclick=\"window.open('$PHP_SELF?&mod=options&action=fileupload&do=quick&area=$full_story_id', '_Addfile', 'HEIGHT=500,resizable=yes,scrollbars=yes,WIDTH=360');return false;\" target=\"_Addfile\"><br />[insert file]</a><br /></p>";


    $data .= "
        (function() {
            CKEDITOR.plugins.addExternal('attach', '".$config_http_script_dir."/cdata/plugins/attach/', 'plugin.js');
        })();";

    return $data;
}

function replace_uploaded_file_templates($data)
{
    global $config_http_script_dir;

    list($output, $news_arr) = $data;

    if ( preg_match_all('~\[filename=(.*?)\]~i', $output, $rep, PREG_SET_ORDER) )
    {
        foreach ($rep as $v)
        {
            $rpl = "<a href=\"$config_http_script_dir/index.php?mod=download&file=$v[1]\">$v[1]</a>";
            $output = str_replace($v[0], $rpl, $output);
        }
    }

    if ( preg_match_all('~\[downloads=(.*?)\]~i', $output, $rep, PREG_SET_ORDER) )
    {
        foreach ($rep as $v)
        {
            $rpl = get_download_values($v[1], 'downloads');
            $output = str_replace($v[0], $rpl, $output);
        }
    }

    if ( preg_match_all('~\[filesize=(.*?)\]~i', $output, $rep, PREG_SET_ORDER) )
    {
        foreach ($rep as $v)
        {
            $rpl = get_download_values($v[1], 'size');
            $output = str_replace($v[0], $rpl, $output);
        }
    }

    return array($output, $news_arr);
}


function download_file($data)
{
    list($system_modules, $mod, $stop) = $data;

    if($mod == 'download')
    {
        $path_to_files = "./uploads";//path to the file upload folder
        $path_to_files_db = "./cdata/files.txt";//path to the files database

        if(isset($_GET['file']) && !empty($_GET['file'])){
            $file = basename(trim($_GET['file']));

            if (is_readable($path_to_files."/".$file)) {
                $content_file_db = file($path_to_files_db);
                $file_db = fopen($path_to_files_db, "w");
                foreach($content_file_db as $single_line){
                    $single_line_arr = explode("|", $single_line);echo $single_line;
                    if($single_line_arr[0] == $file){
                        $new_count = intval($single_line_arr[2]) + 1;
                        fwrite($file_db, $single_line_arr[0]."|".$single_line_arr[1]."|".$new_count."|\n");
                    }
                    else fwrite($file_db, $single_line);
                }
                fclose($file_db);


                header('Pragma: private');
                header('Cache-control: private, must-revalidate');
                header("Content-type: application/force-download");
                header("Content-Disposition: attachment; filename=".$file);
                header("Content-Length: ".filesize($path_to_files."/".$file));

                readfile($path_to_files."/".$file);

                $stop = true;
            }
        }
    }

    return array($system_modules, $mod, $stop);
}

////////////////////////////////////////////
//Function: get_download_values
//Description: Gets the size and number of DL
//             for a file
function get_download_values($file, $what){
    $path_to_files = "./uploads";
    $file_db_file = './cdata/files.txt';
    $file_db_content = file($file_db_file);
    foreach($file_db_content as $single_line){
        $single_line_arr = explode("|", $single_line);
        if($single_line_arr[0] == $file){
            return ($what == "size" ? $single_line_arr[1] : $single_line_arr[2]);
        }
    }
    if (is_readable($path_to_files."/".$file)) {
        $file_db = fopen('./cdata/files.txt', 'a')/* or die("cant open")*/;
        $file_size = formatsize(filesize($path_to_files."/".$file));
        fwrite($file_db, $file."|".$file_size."|0|\n");
        fclose($file_db);
        return ($what == "size" ? $file_size : 0);
    }
}

?>