<?php
// description: Adds a list to your CuteNews panel with all new comments. So you can moderate them before showing the comments on your site.
add_hook('add_comment_checker', 'my_plugin_addcomm');
add_hook('more_options', 'aopt_menu');
add_hook('options_additional_actions', 'aopt_handler');

function my_plugin_addcomm()
{
    global $archive, $time, $name, $mail, $ip, $comments, $id,
           $config_notify_comment, $config_notify_status, $config_timestamp_active,
           $config_date_adjust, $config_notify_email;

    $c4a_file = SERVDIR."/cdata/comments4approve.txt";
    $c4a = fopen($c4a_file, "a") or die("CuteNews can not write to file '$c4a', check if it exists and is proper CHMOD'ed");
    @flock ($c4a_file,2);
    if($archive != ""){ $archive = (int) $archive; }
    fwrite($c4a, (int) $id .'|'. $archive ."|$time|$name|$mail|$ip|$comments||\n");
    @flock ($c4a_file,3);
    fclose($c4a);
    echo("<div style=\"text-align: center;\">Your comment was added and soon will be approved<br /><a href=\"javascript:history.go(-1)\">go back</a></div>");


    if ($config_notify_comment == "yes" and $config_notify_status == "active")
    {
        $date    = date($config_timestamp_active, time() + $config_date_adjust*60);
        $url     = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
        $subject = lang("CuteNews - New Comment Added");
        $message = lang("New Comment was added by %1 on %3 at %4\n\n%2 ", $name, $comments, $date, $url);

        send_mail($config_notify_email, $subject, $message);
    }

    return true;
}

function aopt_menu($options)
{

    $PHP_SELF = PHP_SELF;

    $options[] = array
    (
        'name'              => lang('Approve comments', 'options'),
        'url'               => "$PHP_SELF?mod=options&action=c4a",
        'access'            => ACL_LEVEL_ADMIN,
    );

    return $options;
}

function aopt_handler()
{
    global $member_db;
    $PHP_SELF = PHP_SELF;

    if (REQ('action','GET') == 'c4a')
        require ("c4a/c4a_tools.php");
}
?>