<?php
add_hook('template_replacer_news_before', 'replace_link_to_external');
add_hook('destroy_main', 'auto_sync_rss');
add_hook('field_options_news', 'import_rss_options');
add_hook('cnsc_files', 'import_rss_cnsc_files');

function replace_link_to_external($data)
{
    list($output, $news_arr) = $data;

    if( substr($news_arr[4], 0, 7) == "<#RSS#>" )
    {
        $output = str_replace("[full-link]","<a target=\"_blank\" href=\"".substr($news_arr[4], 7)."\">", $output);
        $output = str_replace("[link]","<a target=\"_blank\" href=\"".substr($news_arr[4], 7)."\">", $output);
        $output = preg_replace("'\\[com-link\\].*?\\[/com-link\\]'si","<!--rss feed can't be commented-->", $output);
    }

    return array($output, $news_arr);
}

function auto_sync_rss()
{
    require_once 'import_rss/rss_reader.php'; // include library
    include 'import_rss/rss_import_function.php';
}

function import_rss_options()
{
    echo "<tr><td colspan='3'><div class='consys_sub'>Import RSS settings</div></td></tr>";
    echo syscon('import_rss_category=30', 'Category to post the feed in|May be multiple, separated by a \',\'');
    echo syscon('import_rss_author=15',  'Author name|by default RSS FEED');
    echo syscon('import_rss_feed_url=30',  'Feed url|Where to import news');
    echo syscon('import_rss_avatar_url=30',  'Avatar url|for feed author');
}

function import_rss_cnsc_files($check_files)
{
    $check_files[] = '/cdata/rss_update.db.php';
    return $check_files;
}

?>