<?php

add_hook('template_replacer_news_before', 'useronline_template_replacer_news_before');

function useronline_template_replacer_news_before($data)
{
    global $ip, $config_timestamp_active;

    list ($output, $news_arr) = $data;

    $cn_do = 'get';
    $subaction = isset($_REQUEST['subaction']) ? $_REQUEST['subaction'] : false;
    if ($subaction == 'showfull' or $subaction == 'showcomments') $cn_do = 'update';

    $file_path = SERVDIR.'/cdata/counter.txt';
    $online_timeout = 120; // seconds
    $time = time();
    $id = $_REQUEST['id'];

    // load current stats into array
    $counter = array();
    foreach (file($file_path) as $line)
    {
        $line = explode("|",$line);
        $counter[$line[0]] = array("views"=>0, "unique views"=>0, "online"=>0);

        if ($line[1] != "")
        {
            foreach (explode(" ",$line[1]) as $part)
            {
                $part = explode(":",$part);
                if ($part[3]>=($time-$online_timeout))$counter[$line[0]]["online"] += 1;
                $counter[$line[0]]["views"] += $part[1];
                $counter[$line[0]][$part[0]] = array($part[1],$part[2],$part[3]);
                $counter[$line[0]]["unique views"] += 1;
            }
        }
    }

    if ($cn_do == "update")
    {
        // update or write this users stats
        if (is_array($counter[$id]))
        {
            if (is_array($counter[$id][$ip]))
            {
                $counter[$id][$ip][0] += 1;
                $counter[$id]["views"] += 1;
                $counter[$id][$ip][2] = $time;
            }
            else
            {
                $counter[$id][$ip] = array(1,$time,$time);
                $counter[$id]["unique views"] += 1;
            }
        }
        elseif (is_numeric($id)) $counter[$id] = array("views"=>1, "unique views"=>1, "online"=>0, $ip => array(1,$time,$time));

        // re-write counter stats
        $fp = fopen($file_path,"w");
        flock($fp, LOCK_EX);

        $write = $counter;
        foreach ($write as $item_id => $item_logs)
        {
            foreach ($item_logs as $log_ip => $log_values)
            {
                if (is_array($log_values))
                {
                    $write[$item_id][$log_ip] = $log_ip.":".implode(":",$log_values);
                }
                else unset($write[$item_id][$log_ip]);
            }

            $write[$item_id] = $item_id."|".implode(" ",$write[$item_id])."|";
        }

        fwrite($fp,implode("\n",$write));
        flock($fp, LOCK_UN);
        fclose($fp);
    }

    $output = str_replace("{page-views}", $counter[$news_arr[0]]["views"], $output);
    $output = str_replace("{unique-views}", $counter[$news_arr[0]]["unique views"], $output);
    $output = str_replace("{your-views}", $counter[$news_arr[0]][$ip][0], $output);
    $output = str_replace("{online}", $counter[$news_arr[0]]["online"], $output);
    $output = str_replace("{first-view}", date($config_timestamp_active,$counter[$news_arr[0]][$ip][1]), $output);

    return array( $output, $news_arr );
}